//	MemUtils.h

#ifndef _H_MemUtils
#define	_H_MemUtils

#ifndef ulong
	typedef	unsigned long	ulong;
	typedef	unsigned short	ushort;
#endif

void			StartTracking(void);
void			ReportTracking(void);

OSErr			TrackSetHandleSize(Handle handleH, ulong bytesL);
OSErr			TrackPtrAndHand(Ptr pointerP, Handle handleH, ulong bytesL);
void			TrackDetachResource(char *what, Handle resH);

void			TrackHandle(Handle it, char *what, ulong sizeL);
Handle			TrackNewHandle(char *what, ulong sizeL);
Handle			TrackNewHandleClear(char *what, ulong sizeL);
void			TrackDisposeHandle(Handle it);

Ptr				TrackNewPtr(char *what, ulong sizeL);
Ptr				TrackNewPtrClear(char *what, ulong sizeL);
void			TrackDisposePtr(Ptr it);

void	memfill(void *mem, char value, unsigned long size);
void	memclr(void *mem, unsigned long size);
#define	structclr(_p)	memclr(&(_p), sizeof(_p))

#endif